<?php
$INC_DIR = $_SERVER['DOCUMENT_ROOT'] . "/v1/app/";
include $INC_DIR . "src/common.php";

$mobile_detect = new Mobile_Detect;
if ($mobile_detect->isMobile() && !$mobile_detect->isTablet()) {
    $url = $configs->mobile_path . "?" . $_SERVER['QUERY_STRING'];
    header("Location: $url");
}
$customer_details = get_customer_details($configs);

?>
<!DOCTYPE html>

<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">

    <title><?php echo $configs->step_1_name; ?></title>
    <meta name="viewport" content="width=device-width,initial-scale=1">

    <link rel="icon" type="image/png" sizes="16x16" href="images/favicon.png">
    <meta name="robots" content="noindex,nofollow">
    <link rel="stylesheet" href="css/app.css">
    <link rel="stylesheet" href="css/modal.css">
    <link rel="stylesheet" type="text/css" href="css/style.css">
    <link href="css/jquery.autocomplete.css" rel="stylesheet">
    <link href="css/app.css" rel="stylesheet">
    <style>
        .autocomplete-suggestions {
            overflow: auto;
            width: auto !important;
        }

        .autocomplete-suggestion {
            overflow: visible;
        }

        form {
            padding: 0;
        }

        .has-error {
            border: 1px solid #ff5e45 !important;
            background-image: url('images/icon-validation-bad.png') !important;
            background-position: right center !important;
            background-repeat: no-repeat !important;
            background-size: 30px !important;
        }

        .no-error {
            background-image: url('images/icon-validation-good.png') !important;
            background-position: right center !important;
            background-repeat: no-repeat !important;

            background-size: 30px !important;
        }
    </style>

    <script type="text/javascript">
        function getDate(days) {
            var monthNames = new Array("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec");
            var now = new Date();
            now.setDate(now.getDate() + days);
            var nowString = monthNames[now.getMonth()] + " " + now.getDate() + ", " + now.getFullYear();
            document.write(nowString);
        }
        var offer_vars = {
            "slug": "v3",
            "customer_service_phone": "<?php echo $configs->customer_service_number; ?>",
            "trial_length": "30 day",
            "shipping_price": "0",
            "msrp": "189.99"
        };
    </script>
    <style type="text/css">
        .lf-progress {
            -webkit-appearance: none;
            -moz-apperance: none;
            width: 100%;
            /* margin: 0 10px; */
            height: 4px;
            border-radius: 3px;
            cursor: pointer;
        }

        .lf-progress:focus {
            outline: none;
            border: none;
        }

        .lf-progress::-moz-range-track {
            cursor: pointer;
            background: none;
            border: none;
            outline: none;
        }

        .lf-progress::-webkit-slider-thumb {
            -webkit-appearance: none !important;
            height: 13px;
            width: 13px;
            border: 0;
            border-radius: 50%;
            background: #0fccce;
            cursor: pointer;
        }

        .lf-progress::-moz-range-thumb {
            -moz-appearance: none !important;
            height: 13px;
            width: 13px;
            border: 0;
            border-radius: 50%;
            background: #0fccce;
            cursor: pointer;
        }

        .lf-progress::-ms-track {
            width: 100%;
            height: 3px;
            cursor: pointer;
            background: transparent;
            border-color: transparent;
            color: transparent;
        }

        .lf-progress::-ms-fill-lower {
            background: #ccc;
            border-radius: 3px;
        }

        .lf-progress::-ms-fill-upper {
            background: #ccc;
            border-radius: 3px;
        }

        .lf-progress::-ms-thumb {
            border: 0;
            height: 15px;
            width: 15px;
            border-radius: 50%;
            background: #0fccce;
            cursor: pointer;
        }

        .lf-progress:focus::-ms-fill-lower {
            background: #ccc;
        }

        .lf-progress:focus::-ms-fill-upper {
            background: #ccc;
        }

        .lf-player-container :focus {
            outline: 0;
        }

        .lf-popover {
            position: relative;
        }

        .lf-popover-content {
            display: inline-block;
            position: absolute;
            opacity: 1;
            visibility: visible;
            transform: translate(0, -10px);
            box-shadow: 0 2px 5px 0 rgba(0, 0, 0, 0.26);
            transition: all 0.3s cubic-bezier(0.75, -0.02, 0.2, 0.97);
        }

        .lf-popover-content.hidden {
            opacity: 0;
            visibility: hidden;
            transform: translate(0, 0px);
        }

        .lf-player-btn-container {
            display: flex;
            align-items: center;
        }

        .lf-player-btn {
            cursor: pointer;
            fill: #999;
            width: 14px;
        }

        .lf-player-btn.active {
            fill: #555;
        }

        .lf-popover {
            position: relative;
        }

        .lf-popover-content {
            display: inline-block;
            position: absolute;
            background-color: #ffffff;
            opacity: 1;

            transform: translate(0, -10px);
            box-shadow: 0 2px 5px 0 rgba(0, 0, 0, 0.26);
            transition: all 0.3s cubic-bezier(0.75, -0.02, 0.2, 0.97);
            padding: 10px;
        }

        .lf-popover-content.hidden {
            opacity: 0;
            visibility: hidden;
            transform: translate(0, 0px);
        }

        .lf-arrow {
            position: absolute;
            z-index: -1;
            content: '';
            bottom: -9px;
            border-style: solid;
            border-width: 10px 10px 0px 10px;
        }

        .lf-left-align,
        .lf-left-align .lfarrow {
            left: 0;
            right: unset;
        }

        .lf-right-align,
        .lf-right-align .lf-arrow {
            right: 0;
            left: unset;
        }

        .lf-text-input {
            border: 1px #ccc solid;
            border-radius: 5px;
            padding: 3px;
            width: 60px;
            margin: 0;
        }

        .lf-color-picker {
            display: flex;
            flex-direction: row;
            justify-content: space-between;
            height: 90px;
        }

        .lf-color-selectors {
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }

        .lf-color-component {
            display: flex;
            flex-direction: row;
            font-size: 12px;
            align-items: center;
            justify-content: center;
        }

        .lf-color-component strong {
            width: 40px;
        }

        .lf-color-component input[type='range'] {
            margin: 0 0 0 10px;
        }

        .lf-color-component input[type='number'] {
            width: 50px;
            margin: 0 0 0 10px;
        }

        .lf-color-preview {
            font-size: 12px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: space-between;
            padding-left: 5px;
        }

        .lf-preview {
            height: 60px;
            width: 60px;
        }

        .lf-popover-snapshot {
            width: 150px;
        }

        .lf-popover-snapshot h5 {
            margin: 5px 0 10px 0;
            font-size: 0.75rem;
        }

        .lf-popover-snapshot a {
            display: block;
            text-decoration: none;
        }

        .lf-popover-snapshot a:before {
            content: '⥼';
            margin-right: 5px;
        }

        .lf-popover-snapshot .lf-note {
            display: block;
            margin-top: 10px;
            color: #999;
        }

        .lf-player-controls>div {
            margin-right: 5px;
            margin-left: 5px;
        }

        .lf-player-controls>div:first-child {
            margin-left: 0px;
        }

        .lf-player-controls>div:last-child {
            margin-right: 0px;
        }
    </style>
</head>

<body class="main-page">

    <div class="row tablet__show cmp-hide">
        <div class="attention-block">
            <div class="inner-block">
                <div class="col-sm-12 attention special">
                    <div class="icon-exclamation"></div>
                    Due to increased demand for our offers with free bottles we have a limited supply. As of <span style="color:#db3d24" class="date-container">
                        <script type="text/javascript">
                            getDate(0);
                        </script>
                    </span> we currently have the product <span style="color:#db3d24">IN STOCK</span> and are ready to ship within 24 hours of purchase.
                    <div class="icon-close"></div>
                </div>
            </div>
        </div>
    </div>

    <div class="wrapper">

        <section class="header-section">
            <div class="inner-block clearfix">
                <div class="logo left"></div>
                <a href="#" class="button scroll-link-button right">Order Now</a>
                <nav class="right">
                    <div class="right__content">
                        <p class="right__content__title">Get My Free Bottle!</p>
                        <p class="right__content__text"><span class="primary__green">Voted #1</span> SkinCare Product in <span class="country-name">USA</span> </p>
                    </div>
                </nav>
                <div class="clear"></div>
                <div class="clear"></div>
            </div>
        </section>

        <div class="row tablet__hide cmp-hide">
            <div class="attention-block">
                <div class="inner-block">
                    <div class="col-sm-12 attention special">
                        <div class="icon-exclamation"></div>
                        Due to increased demand for our offers with free bottles we have a limited supply. As of <span style="color:#db3d24" class="date-container">
                            <script type="text/javascript">
                                getDate(0);
                            </script>
                        </span> we currently have the product <span style="color:#db3d24">IN STOCK</span> and are ready to ship within 24 hours of purchase.
                        <div class="icon-close"></div>
                    </div>
                </div>
            </div>
        </div>

        <section class="first-section section" id="first-section">
            <div class="inner-block clearfix">
                <figure class="woman-image mobile__show"></figure>
                <main class="left">
                    <div class="mobile__background">
                        <h2>Mole &amp; Skin Tag Corrector Serum </h2>
                    </div>
                    <p>This is a fast and easy solution for unwanted moles &amp; pesky skin tags works in the privacy of your own home</p>
                    <figure class="product-image mobile__hide">
                        <img src="images/product.png" alt="" class="s1-prd2">
                        <img src="images/product.png" alt="" class="s1-prd1">
                    </figure>
                </main>
                <figure class="woman-image mobile__hide"></figure>
                <figure class="labels__icon"></figure>
                <figure class="product-image mobile__show">
                    <img src="images/product.png" alt="" class="s1-prd2">
                    <img src="images/product.png" alt="" class="s1-prd1">
                </figure>
                <ul class="list__bnr">
                    <li><span>All-Natural</span><br>Formula<p></p>
                    </li>
                    <li><span>Removes Skin Tags</span><br>Safely &amp; Painlessly<p></p>
                    </li>
                    <li><span>Works on</span><br>All Skin Types<p></p>
                    </li>
                    <li><span>Fast Acting</span><br>Liquid Solution </li>
                </ul>
                <div class="inner-block__bottom"> </div>
                <a href="#" class="hide-mobile">
                    <button class="button button_green__style mobile__show desktop__hide">Order Now</button>
                </a>
                <a id="index-form" name="formTop"></a>

                <!-- <form name="prospect_form1" class="kform form123 prospect-form form" id="payment-form" method="POST" action="/v1/app/src/ajax.php" onSubmit="return validate_optin_form()"> -->
                <form id='payment-form' class='prospect-form form' method="POST" action="/v1/app/src/ajax.php" onSubmit="return validate_optin_form()">  

                    <input type="hidden" name="device" value="desktop">
                    <input type="hidden" name="pgtag" value="dindex">
                    <input type="hidden" name="pk" value="5">
                    <input type="hidden" name="shippingCountry" value="US">
                    <?php
                    foreach ($customer_details['affiliate_details'] as $key => $value) {
                        echo "<input type='hidden' name='" . $key . "' value='" . $value . "'>";
                    }
                    ?>
                    <!-- <input type="hidden" name="AFFID" value="C3149BF8">
                    <input type="hidden" name="c1" value="2">
                    <input type="hidden" name="C1" value="2">
                    <input type="hidden" name="c2" value="TEST-DTC-LP">
                    <input type="hidden" name="C2" value="TEST-DTC-LP">
                    <input type="hidden" name="c3" value="15713322">
                    <input type="hidden" name="C3" value="15713322"> -->
                    <header> Tell Us Where To Ship Your<span> Bottle Today!</span> </header>
                    <div class="phone-6 promo-field form-holder">
                        <label for="promo">Your discount code <span>activated</span></label>
                        <input class="form-control" id="promo" placeholder="Promo code" disabled="" title="Promo code" type="text" value="DA25171525">
                    </div>
                    <div class="form-holder">
                        <input type="text" name="firstName" id="fields_fname" placeholder="First Name" class="first-name" onkeyup="javascript: this.value = this.value.replace(/[^a-zA-Z0-9\ ]/g, &#39;&#39;);" onchange="javascript: this.value = this.value.replace(/[^a-zA-Z0-9\ ]/g, &#39;&#39;);">
                    </div>
                    <div class="form-holder">
                        <input type="text" name="lastName" id="fields_lname" placeholder="Last Name" onkeyup="javascript: this.value = this.value.replace(/[^a-zA-Z0-9\ ]/g, &#39;&#39;);" onchange="javascript: this.value = this.value.replace(/[^a-zA-Z0-9\ ]/g, &#39;&#39;);">
                    </div>
                    <div class="form-holder">
                        <input type="tel" name="shippingZip" id="fields_zip" placeholder="Zip/Postal Code" minlength="5" maxlength="5" value="" onkeyup="javascript: this.value = this.value.replace(/[^0-9]/g, &#39;&#39;);">
                    </div>
                    <div class="form-holder">
                        <input type="text" name="shippingAddress1" id="fields_address1" placeholder="Street Address" onkeyup="javascript: this.value = this.value.replace(/[^a-zA-Z0-9\ \,\-]/g, &#39;&#39;);" onchange="javascript: this.value = this.value.replace(/[^a-zA-Z0-9\ \,\-]/g, &#39;&#39;);">
                    </div>
                    <div class="form-holder">
                        <input type="text" name="shippingCity" id="fields_city" placeholder="City" onkeyup="javascript: this.value = this.value.replace(/[^a-zA-Z0-9\ ]/g, &#39;&#39;);" onchange="javascript: this.value = this.value.replace(/[^a-zA-Z0-9\ ]/g, &#39;&#39;);">
                    </div>
                    <div class="form-holder">
                        <select name="shippingState" id="fields_state" data-selected="" data-error-message="State is required">
                            <option value="" onclick="">Select State</option>
                            <option value="AL">Alabama (AL)</option>
                            <option value="AK">Alaska (AK)</option>
                            <option value="AS">American Samoa (AS)</option>
                            <option value="AZ">Arizona (AZ)</option>
                            <option value="AR">Arkansas (AR)</option>
                            <option value="AE">Armed Forces (AE)</option>
                            <option value="AA">Armed Forces Americas (AA)</option>
                            <option value="AP">Armed Forces Pacific (AP)</option>
                            <option value="CA">California (CA)</option>
                            <option value="CO">Colorado (CO)</option>
                            <option value="CT">Connecticut (CT)</option>
                            <option value="DE">Delaware (DE)</option>
                            <option value="DC">District of Columbia (DC)</option>
                            <option value="FM">Federated States of Micronesia (FM)</option>
                            <option value="FL">Florida (FL)</option>
                            <option value="GA">Georgia (GA)</option>
                            <option value="GU">Guam (GU)</option>
                            <option value="HI">Hawaii (HI)</option>
                            <option value="ID">Idaho (ID)</option>
                            <option value="IL">Illinois (IL)</option>
                            <option value="IN">Indiana (IN)</option>
                            <option value="IA">Iowa (IA)</option>
                            <option value="KS">Kansas (KS)</option>
                            <option value="KY">Kentucky (KY)</option>
                            <option value="LA">Louisiana (LA)</option>
                            <option value="ME">Maine (ME)</option>
                            <option value="MD">Maryland (MD)</option>
                            <option value="MA">Massachusetts (MA)</option>
                            <option value="MI">Michigan (MI)</option>
                            <option value="MN">Minnesota (MN)</option>
                            <option value="MS">Mississippi (MS)</option>
                            <option value="MO">Missouri (MO)</option>
                            <option value="MT">Montana (MT)</option>
                            <option value="NE">Nebraska (NE)</option>
                            <option value="NV">Nevada (NV)</option>
                            <option value="NH">New Hampshire (NH)</option>
                            <option value="NJ">New Jersey (NJ)</option>
                            <option value="NM">New Mexico (NM)</option>
                            <option value="NY">New York (NY)</option>
                            <option value="NC">North Carolina (NC)</option>
                            <option value="ND">North Dakota (ND)</option>
                            <option value="MP">Northern Mariana Islands (MP)</option>
                            <option value="OH">Ohio (OH)</option>
                            <option value="OK">Oklahoma (OK)</option>
                            <option value="OR">Oregon (OR)</option>
                            <option value="PA">Pennsylvania (PA)</option>
                            <option value="PR">Puerto Rico (PR)</option>
                            <option value="MH">Republic of Marshall Islands (MH)</option>
                            <option value="RI">Rhode Island (RI)</option>
                            <option value="SC">South Carolina (SC)</option>
                            <option value="SD">South Dakota (SD)</option>
                            <option value="TN">Tennessee (TN)</option>
                            <option value="TX">Texas (TX)</option>
                            <option value="UT">Utah (UT)</option>
                            <option value="VT">Vermont (VT)</option>
                            <option value="VI">Virgin Islands of the U.S. (VI)</option>
                            <option value="VA">Virginia (VA)</option>
                            <option value="WA">Washington (WA)</option>
                            <option value="WV">West Virginia (WV)</option>
                            <option value="WI">Wisconsin (WI)</option>
                            <option value="WY">Wyoming (WY)</option>
                        </select>
                    </div>
                    <div class="form-holder">
                        <input type="email" name="email" id="fields_email" placeholder="Email">
                    </div>
                    <div class="form-holder">
                        <input type="tel" name="phone" id="fields_phone" placeholder="Telephone" value="" maxlength="12">
                    </div>
                    <button type="submit" class="button">Rush My Order!<span>Get Your Bottle Faster!</span></button>
                    <div class="icons"></div>
                </form>

                <div class="clear"></div>
            </div>
        </section>

        <section class="second-section section" id="second-section">
            <div class="inner-block">
                <main>
                    <h2>What is <?php echo $configs->step_1_name; ?>?</h2>
                    <p><?php echo $configs->step_1_name; ?> is a powerful serum made from natural ingredients. With just a few drops applied to a blemish, the serum works to penetrate to the root of a mole or skin tag, and triggers a rush of white blood cells to the blemish, which starts the removal and healing.</p>
                    <ul>
                        <li>Revolutionary new all-natural formula</li>
                        <li>Works on moles &amp; skin tags anywhere on your body</li>
                        <li>Delivers FAST results in as little as 8 hours</li>
                    </ul>
                    <h3><?php echo $configs->step_1_name; ?> is specially formulated and manufactured in the United States of America, in a state of the art FDA approved facility.</h3>
                    <a href="javascript:void(0)" class="button mobile-button" id="mobile-order-form">Rush my order</a>
                    <figure class="bottles-image">
                        <img src="images/product.png" alt="" class="s2-prd2">
                        <img src="images/product.png" alt="" class="s2-prd1">
                    </figure>
                    <figure class="arrow"></figure>
                </main>
            </div>
        </section>

        <section class="fifth-section v2">
            <div class="inner-block">
                <h2><?php echo $configs->step_1_name; ?> Works to Eliminate...</h2>
                <main>
                    <article class="item-1">
                        <figure><span></span></figure>
                        <h3>Skin Tags</h3>
                    </article>
                    <article class="item-2">
                        <figure><span></span></figure>
                        <h3>Dark Moles</h3>
                    </article>
                    <article class="item-3">
                        <figure><span></span></figure>
                        <h3>Light Moles</h3>
                    </article>
                    <article class="item-4">
                        <figure><span></span></figure>
                        <h3>Small Warts</h3>
                    </article>
                    <article class="item-5">
                        <figure><span></span></figure>
                        <h3>Big Warts</h3>
                    </article>
                </main>
            </div>
        </section>

        <section class="third-section section" id="third-section">
            <div class="inner-block">
                <h2>How Does <?php echo $configs->step_1_name; ?> Work?</h2>
                <p><?php echo $configs->step_1_name; ?> gives you the freedom to remove all your moles or skin tags in the comfort of your own home. No more doctors, no more surgery or insurance hassles.</p>
                <main>
                    <img src="images/product.png" alt="" class="s3-prd">
                    <article class="item-1 left">
                        <h4>With <?php echo $configs->step_1_name; ?> Applied</h4>
                        <figure></figure>
                        <a href="javascript:void(0)" class="more-button">Read More</a>
                    </article>
                    <article class="item-2 right">
                        <h4>8 Hours After Application</h4>
                        <figure></figure>
                        <a href="javascript:void(0)" class="more-button">Read More</a>
                    </article>
                    <article class="item-3 left">
                        <h4>Scab is Gone and Healing Nicely</h4>
                        <figure></figure>
                        <a href="javascript:void(0)" class="more-button">Read More</a>
                    </article>
                    <article class="item-4 right">
                        <h4>No Trace The Mole Ever Existed</h4>
                        <figure></figure>
                        <a href="javascript:void(0)" class="more-button">Read More</a>
                    </article>
                    <div class="clear"></div>

                    <div class="info item-1">
                        <div class="inner">
                            <h3>Step 1</h3>
                            When you apply <?php echo $configs->step_1_name; ?> to the blemish, the active ingredients will penetrate to the root and alert your immune system. This immune response will send white blood cells to the blemish and start the removal and healing process.
                            <footer><a href="javascript:void(0)" class="next-info-link">Next Step</a></footer>
                            <footer><a href="javascript:void(0)" class="close-info-link">Close</a></footer>
                        </div>
                    </div>

                    <div class="info item-2">
                        <div class="inner">
                            <h3>Step 2</h3>
                            The area may become slightly inflamed and a scab will form over the blemish. Once the scab forms <?php echo $configs->step_1_name; ?> has done its job and your body will do the rest. This means stop applying <?php echo $configs->step_1_name; ?> and let the scab heal on its own.
                            <footer><a href="javascript:void(0)" class="next-info-link">Next Step</a></footer>
                            <footer><a href="javascript:void(0)" class="close-info-link">Close</a></footer>
                        </div>
                    </div>

                    <div class="info item-3">
                        <div class="inner">
                            <h3>Step 3</h3>
                            Be sure not to pick at the scab and let it fall off naturally. Once the scab is gone, make sure to apply <?php echo $configs->step_1_name; ?>'s Skin Repair Cream or a Neosporin type product. This will accelerate the healing process and limit the risk of scarring.
                            <footer><a href="javascript:void(0)" class="next-info-link">Next Step</a></footer>
                            <footer><a href="javascript:void(0)" class="close-info-link">Close</a></footer>
                        </div>
                    </div>

                    <div class="info item-4">
                        <div class="inner">
                            <h3>Step 4</h3>
                            Once fully healed there will be little to no trace of the mole or skin tag. When done correctly, they will be gone for good and never return.
                            <footer><a href="javascript:void(0)" class="close-info-link">Close</a></footer>
                        </div>
                    </div>

                </main>

                <h3>Join the many thousands of people who are enjoying their blemish free skin today! Hurry and claim your bottle now while supplies last!</h3>
                <a href="" class="button scroll-link-button">Rush My Order<span class="risk-free"></span></a>

                <div class="skin-table">
                    <h2>How Does Skin Tag Remover Compare?</h2>
                    <table>
                        <tbody>
                            <tr class="table-product">
                                <td></td>
                                <td class="table-blue"><img src="images/product.png" alt="" width="60"> <span>SkinCell</span></td>
                                <td><img src="images/chart-prod2.png" alt=""> <span>Other Product</span></td>
                                <td class="hide-mobile"><img src="images/chart-prod3.png" alt=""> <span>Other Product 2</span></td>
                                <td><img src="images/chart-prod4.png" alt=""> <span>Surgery</span></td>
                            </tr>
                            <tr class="table-line">
                                <td class="table-title"><span>Remove skin tags</span></td>
                                <td class="table-blue"><span>YES</span></td>
                                <td><span>YES</span></td>
                                <td class="hide-mobile"><span>YES</span></td>
                                <td><span>YES</span></td>
                            </tr>
                            <tr class="table-line">
                                <td class="table-title"><span>Remove moles</span></td>
                                <td class="table-blue"><span>YES</span></td>
                                <td><span>NO</span></td>
                                <td class="hide-mobile"><span>YES</span></td>
                                <td><span>YES</span></td>
                            </tr>
                            <tr class="table-line">
                                <td class="table-title"><span>ALL-NATURAL</span></td>
                                <td class="table-blue"><span>YES</span></td>
                                <td><span>YES</span></td>
                                <td class="hide-mobile"><span>NO</span></td>
                                <td><span>YES</span></td>
                            </tr>
                            <tr class="table-line">
                                <td class="table-title"><span>Top Quality Ingredients</span></td>
                                <td class="table-blue"><span>YES</span></td>
                                <td><span>NO</span></td>
                                <td class="hide-mobile"><span>NO</span></td>
                                <td><span>YES</span></td>
                            </tr>
                            <tr class="table-line">
                                <td class="table-title"><span>Allergic safety</span></td>
                                <td class="table-blue"><span>YES</span></td>
                                <td><span>NO</span></td>
                                <td class="hide-mobile"><span>NO</span></td>
                                <td><span>YES</span></td>
                            </tr>
                            <tr class="table-line">
                                <td class="table-title"><span>Works On All Skin Types</span></td>
                                <td class="table-blue"><span>YES</span></td>
                                <td><span>YES</span></td>
                                <td class="hide-mobile"><span>NO</span></td>
                                <td><span>YES</span></td>
                            </tr>
                            <tr class="table-line">
                                <td class="table-title"><span>FAST results in as little as 8 hours</span></td>
                                <td class="table-blue"><span>YES</span></td>
                                <td><span>NO</span></td>
                                <td class="hide-mobile"><span>NO</span></td>
                                <td><span>NO</span></td>
                            </tr>
                            <tr class="table-line">
                                <td class="table-title"><span>Painless</span></td>
                                <td class="table-blue"><span>YES</span></td>
                                <td><span>YES</span></td>
                                <td class="hide-mobile"><span>YES</span></td>
                                <td><span>NO</span></td>
                            </tr>
                            <tr class="table-line">
                                <td class="table-title"><span>Price</span></td>
                                <td class="table-blue"><span>from <span class="product-price"></span>$39.99</span></td>
                                <td><span>$80.00</span></td>
                                <td class="hide-mobile"><span>$69.99</span></td>
                                <td><span>$3000</span></td>
                            </tr>
                            <tr class="table-line">
                                <td class="table-line__last"><span>Recommended Choice</span></td>
                                <td class="table-blue"><img src="images/check-yellow.png" alt="" class="bottom-img"></td>
                            </tr>
                        </tbody>
                    </table>
                </div>

            </div>
        </section>

        <section class="fourth-section section" id="fourth-section">
            <div class="inner-block">
                <h2>Top Quality Ingredients. Top Results.</h2>
                <p><?php echo $configs->step_1_name; ?> is a refined old world remedy that has been used for centuries. Our researchers have combined the power of Zincum Muriaticum and Sanguinaria Canadensis in an easy to use, clear and odorless, liquid serum for optimal results &amp; easy application.</p>
                <p><b><?php echo $configs->step_1_name; ?> is serum made from premium quality all-natural ingredients from around the world</b></p>
                <main>
                    <div class="arrow top"></div>
                    <figure class="bottle-image">
                        <img src="images/product.png" alt="" class="s4-prd2">
                        <img src="images/product.png" alt="" class="s4-prd1">
                    </figure>
                    <div class="arrow bottom"></div>
                    <article class="item-1">
                        <figure></figure>
                        <div class="text">
                            <h3>Sanguinaria Canadensis</h3>
                            Sanguinaria Canadensis is a perennial, herbaceous flowering plant native to eastern North America. This flower has been historically used in ancient remedies by Native Americans for centuries. Sanguinaria Canadensis is a primary component which stimulate a rush of white blood cells to remove a blemish.
                        </div>
                        <div class="clear"></div>
                    </article>
                    <article class="item-2">
                        <figure></figure>
                        <div class="text">
                            <h3>Zincum Muriaticum</h3>
                            Zincum Muriaticum is a mineral that is found in Earth's crust, and has strong antiseptic and disinfectant qualities, which contribute to its effectiveness. Zincum Muriaticum is a natural and powerful skin irritant that works to create a small layer of scabbing over the mole or skin tag blemished area, causing it to begin healing.
                        </div>
                        <div class="clear"></div>
                    </article>
                </main>
                <a href="javascript:void(0)" class="button scroll-link-button">Rush My Order<span>Get Your Package Right Now!</span></a>
                <a href="javascript:void(0)" class="button mobile-button" id="mobile-order-form">Rush My Order<span>Get Your Package Right Now!</span></a>
            </div>
        </section>

        <section class="fifth-section section" id="fifth-section">
            <div class="inner-block">
                <h2>Real People. Real Results.</h2>
                <p>Millions of men and women worldwide are raving about <?php echo $configs->step_1_name; ?> and its positive effects on moles and skin tags. Read below the success stories of our customers and see for yourself.</p>

                <div class="carousel-testimonials owl-carousel owl-theme owl-drag">
                    <div class="owl-wrapper-outer">
                        <div class="owl-wrapper owl-stage" style="width: 9120px; transform: translate3d(-4180px, 0px, 0px); transition: 0.4s;">
                            <div class="owl-item cloned" style="width: 380px;">
                                <article class="item-7">
                                    <figure></figure>
                                    <div class="text">
                                        <p>My skin is very pale and as I started to age small black beauty marks that were raised started to form on my neck. I just hated feeling them every time I touched my neck or got dressed. I went to a doctor to ask about removing them and he asked for hundreds of dollars, I got discouraged. With a little online research I found <?php echo $configs->step_1_name; ?>, ordered it and it came in 2 days, and within a couple of applications my marks started to disappear. I couldn’t be happier.</p>
                                        <b>- Jennifer, Nevada</b>
                                    </div>
                                </article>
                            </div>
                            <div class="owl-item cloned" style="width: 380px;">
                                <article class="item-8">
                                    <figure></figure>
                                    <div class="text">
                                        <p>Some years back this bump on my nose started to form. First it was barely noticeable and then over the past few months is started to grow a bit faster and then faster. I saw a doctor about it and he told that it was nothing to worry about, that we’re all human and have these things. I thought even if we do, I’d like to get some cosmetic work done, and then I heard about <?php echo $configs->step_1_name; ?>. I ordered it up and tried it out, and with 1 use my bump was removed.</p>
                                        <b>- Andy, New Jersey</b>
                                    </div>
                                </article>
                            </div>
                            <div class="owl-item cloned" style="width: 380px;">
                                <article class="item-9">
                                    <figure></figure>
                                    <div class="text">
                                        <p>I had a few moles on my body that I have always hated, and this one on my face which was my most hated. I tried so many different creams and lotions and nothing worked, until I found this clear serum by <?php echo $configs->step_1_name; ?>. Just from the way it was packaged and arrived at my house I knew this was going to be powerful stuff, and it was! <?php echo $configs->step_1_name; ?> was applied to ally my moles and needless to say, they are all gone, like real magic. </p>
                                        <b>- Jim, Tennessee </b>
                                    </div>
                                </article>
                            </div>
                            <div class="owl-item cloned" style="width: 380px;">
                                <article class="item-10">
                                    <figure></figure>
                                    <div class="text">
                                        <p>My looks have always bothered me, a lot because of my weight but also because I had growths in awkward places on my face for my whole life. I never wanted to have surgery done, I was always afraid of ‘going under the knife’, but I was always open to trying creams and some did work. Nothing worked as well as <?php echo $configs->step_1_name; ?>, with just a few weeks my growths shrunk until they became invisible. Thank you <?php echo $configs->step_1_name; ?>. </p>
                                        <b>- Annabelle, Virginia</b>
                                    </div>
                                </article>
                            </div>
                            <div class="owl-item cloned" style="width: 380px;">
                                <article class="item-11">
                                    <figure></figure>
                                    <div class="text">
                                        <p>I am a mother of 4 and wife to a fantastic husband who says he loves me no matter how I look, but I want to look good for him. Naturally this mark on my face bothered me because as I grew older it grew too! My best friend Natalie told me about how she used <?php echo $configs->step_1_name; ?> and it worked fast and was reliable, so I tried it, and my mark slowly shrank until finally I could only feel it a small little bit and but unable to see it. I am very happy with my results.</p>
                                        <b>- Paulina, California</b>
                                    </div>
                                </article>
                            </div>
                            <div class="owl-item cloned" style="width: 380px;">
                                <article class="item-12">
                                    <figure></figure>
                                    <div class="text">
                                        <p>Over my ear has been a growth that annoyed me every time I brushed my hair forever. I am a little bit lazy, so even though I could get it removed, I always thought I would, but never did. The fact that <?php echo $configs->step_1_name; ?> comes to your door, in just days is so convenient. I bought it online, opened the box, and applied it, and within a few days my growth started to get smaller. After some weeks it was totally gone, how much easier can it get!</p>
                                        <b>- Anita, South Carolina</b>
                                    </div>
                                </article>
                            </div>
                            <div class="owl-item" style="width: 380px;">
                                <article class="item-1">
                                    <figure></figure>
                                    <div class="text">
                                        <p>I have been struggling with a mole on my neck below my ear for years, and I really did not want to go to a doctor to have it surgically removed. I’ve tried many over the counter mole products from my local pharmacy, and nothing worked. My mom told me about <?php echo $configs->step_1_name; ?>, and then bought it for me as a gift, thanks mom! Immediately after I applied <?php echo $configs->step_1_name; ?> I was able to feel it working, and my mole is almost gone!</p>
                                        <b>- Liza, New York</b>
                                    </div>
                                </article>
                            </div>
                            <div class="owl-item" style="width: 380px;">
                                <article class="item-2">
                                    <figure></figure>
                                    <div class="text">
                                        <p>When I was about 25 this mole started to develop on my chin, and started to get in the way whenever I would shave, and would sometimes get irritated. I have thought about removing it for very long time and had always procrastinated, and then I heard about <?php echo $configs->step_1_name; ?>. I ordered it up online and it came to my door in a couple of days, and I cracked it open and put the drops on my mole, I felt it starting to work right away.</p>
                                        <b>- Jonny, Nevada</b>
                                    </div>
                                </article>
                            </div>
                            <div class="owl-item" style="width: 380px;">
                                <article class="item-3">
                                    <figure></figure>
                                    <div class="text">
                                        <p>These moles on my cheeks have been with me since birth and had never really bothered me until a couple of years ago. So many advancements in skin therapy like laser hair removal got me thinking that maybe I should try to remove my moles and have clear skin. I read online about <?php echo $configs->step_1_name; ?> and gave it a try, and I couldn’t be happier. My moles have shrunk significantly and my skin is smooth, soft and I feel more confident.</p>
                                        <b>- Marissa, Florida</b>
                                    </div>
                                </article>
                            </div>
                            <div class="owl-item" style="width: 380px;">
                                <article class="item-4">
                                    <figure></figure>
                                    <div class="text">
                                        <p>Born with a mole over your eye is tough to deal with growing up. I used to beg my parents to take me to get it removed, and eventually I learned that it was a part of me, and there was nothing I could do about it. I was surfing online and came across an advertisement and couldn’t believe what I was reading and quickly ordered. Within a few days my mole started shrinking, and after a few applications these are my results!</p>
                                        <b>- Patricia, Georgia </b>
                                    </div>
                                </article>
                            </div>
                            <div class="owl-item" style="width: 380px;">
                                <article class="item-5">
                                    <figure></figure>
                                    <div class="text">
                                        <p><?php echo $configs->step_1_name; ?> changed the way I feel about myself, every time I look in the mirror I am just amazed at how well it worked to remove my growth. I would recommend <?php echo $configs->step_1_name; ?> to anyone that is even thinking about a surgical procedure, this gets the job done, and fast. Thank you Skicell Advanced, your product changed my life.</p>
                                        <b>- Kevin, Oregon </b>
                                    </div>
                                </article>
                            </div>
                            <div class="owl-item active" style="width: 380px;">
                                <article class="item-6">
                                    <figure></figure>
                                    <div class="text">
                                        <p>My wife bought me a few bottles of <?php echo $configs->step_1_name; ?> because she saw it online and read great things about it. I honestly didn’t care so much about my mole, but it bothered her when I kissed her, and she always asked me to get it removed. For my wife, I tried this product and thought it wouldn’t work, but it did! Now my wife and kids think I am my most handsome ever and that makes me happy. I recommend this to anyone looking for a great result.</p>
                                        <b>- Hector, Texas </b>
                                    </div>
                                </article>
                            </div>
                            <div class="owl-item active" style="width: 380px;">
                                <article class="item-7">
                                    <figure></figure>
                                    <div class="text">
                                        <p>My skin is very pale and as I started to age small black beauty marks that were raised started to form on my neck. I just hated feeling them every time I touched my neck or got dressed. I went to a doctor to ask about removing them and he asked for hundreds of dollars, I got discouraged. With a little online research I found <?php echo $configs->step_1_name; ?>, ordered it and it came in 2 days, and within a couple of applications my marks started to disappear. I couldn’t be happier.</p>
                                        <b>- Jennifer, Nevada</b>
                                    </div>
                                </article>
                            </div>
                            <div class="owl-item active" style="width: 380px;">
                                <article class="item-8">
                                    <figure></figure>
                                    <div class="text">
                                        <p>Some years back this bump on my nose started to form. First it was barely noticeable and then over the past few months is started to grow a bit faster and then faster. I saw a doctor about it and he told that it was nothing to worry about, that we’re all human and have these things. I thought even if we do, I’d like to get some cosmetic work done, and then I heard about <?php echo $configs->step_1_name; ?>. I ordered it up and tried it out, and with 1 use my bump was removed.</p>
                                        <b>- Andy, New Jersey</b>
                                    </div>
                                </article>
                            </div>
                            <div class="owl-item" style="width: 380px;">
                                <article class="item-9">
                                    <figure></figure>
                                    <div class="text">
                                        <p>I had a few moles on my body that I have always hated, and this one on my face which was my most hated. I tried so many different creams and lotions and nothing worked, until I found this clear serum by <?php echo $configs->step_1_name; ?>. Just from the way it was packaged and arrived at my house I knew this was going to be powerful stuff, and it was! <?php echo $configs->step_1_name; ?> was applied to ally my moles and needless to say, they are all gone, like real magic. </p>
                                        <b>- Jim, Tennessee </b>
                                    </div>
                                </article>
                            </div>
                            <div class="owl-item" style="width: 380px;">
                                <article class="item-10">
                                    <figure></figure>
                                    <div class="text">
                                        <p>My looks have always bothered me, a lot because of my weight but also because I had growths in awkward places on my face for my whole life. I never wanted to have surgery done, I was always afraid of ‘going under the knife’, but I was always open to trying creams and some did work. Nothing worked as well as <?php echo $configs->step_1_name; ?>, with just a few weeks my growths shrunk until they became invisible. Thank you <?php echo $configs->step_1_name; ?>. </p>
                                        <b>- Annabelle, Virginia</b>
                                    </div>
                                </article>
                            </div>
                            <div class="owl-item" style="width: 380px;">
                                <article class="item-11">
                                    <figure></figure>
                                    <div class="text">
                                        <p>I am a mother of 4 and wife to a fantastic husband who says he loves me no matter how I look, but I want to look good for him. Naturally this mark on my face bothered me because as I grew older it grew too! My best friend Natalie told me about how she used <?php echo $configs->step_1_name; ?> and it worked fast and was reliable, so I tried it, and my mark slowly shrank until finally I could only feel it a small little bit and but unable to see it. I am very happy with my results.</p>
                                        <b>- Paulina, California</b>
                                    </div>
                                </article>
                            </div>
                            <div class="owl-item" style="width: 380px;">
                                <article class="item-12">
                                    <figure></figure>
                                    <div class="text">
                                        <p>Over my ear has been a growth that annoyed me every time I brushed my hair forever. I am a little bit lazy, so even though I could get it removed, I always thought I would, but never did. The fact that <?php echo $configs->step_1_name; ?> comes to your door, in just days is so convenient. I bought it online, opened the box, and applied it, and within a few days my growth started to get smaller. After some weeks it was totally gone, how much easier can it get!</p>
                                        <b>- Anita, South Carolina</b>
                                    </div>
                                </article>
                            </div>

                        </div>
                    </div>
                    <div class="owl-nav disabled">
                        <button type="button" role="presentation" class="owl-prev">
                            <span aria-label="Previous">‹</span></button>
                        <button type="button" role="presentation" class="owl-next"><span aria-label="Next">›</span></button>
                    </div>
                    <div class="owl-dots">
                        <!-- <button role="button" class="owl-dot"><span></span></button>
						<button role="button" class="owl-dot active"><span></span></button> 
						 <button role="button" class="owl-dot"><span></span></button>
						<button role="button" class="owl-dot"><span></span></button> -->
                    </div>
                </div>
            </div>
        </section>

        <section class="six-section">
            <div class="inner-block">
                <main>
                    <h2>Clean Skin Without Surgery!</h2>
                    <p><?php echo $configs->step_1_name; ?> is changing the way people heal and remove moles and skin tags. Join thousands of others who are already enjoying beautiful and blemish free skin today!</p>
                    <h4>Order your supply of <?php echo $configs->brand; ?> now! <br>
                        Start feeling great about your skin again. </h4>
                    <figure class="bottles-image">
                        <img src="images/product.png" alt="" class="s6-prd2">
                        <img src="images/product.png" alt="" class="s6-prd1">
                        <img src="images/s6-seal.png" alt="" class="s6-seal">
                    </figure>
                    <a href="javascript:void(0)" class="button scroll-link-button">Try <?php echo $configs->brand; ?><span>30% Instant Online Discount Today!</span><span class="off30"></span></a>
                    <a href="javascript:void(0)" class="button mobile-button" id="mobile-order-form">Try <?php echo $configs->brand; ?><span>30% Instant Online Discount Today!</span><span class="off30"></span></a>
                </main>
            </div>
        </section>

        <section class="footer-section">
            <div class="inner-block">
                <div class="block left">
                    <div class="logo" style="margin-top:5px"></div>
                </div>
                <nav class="left">
                    <h4>Information</h4>
                    <ul class="left">
                        <li><a href="javascript:void(0);" onclick="openNewWindow('disclosures/privacy.php','modal');">Privacy</a></li>
                        <li><a href="javascript:void(0);" onclick="openNewWindow('disclosures/wireless.php','modal');">Wireless Policy</a></li>
                    </ul>
                    <ul class="left">
                        <li><a href="javascript:void(0);" onclick="openNewWindow('disclosures/terms.php','modal');">Terms</a></li>
                    </ul>
                    <div class="clear"></div>
                </nav>
                <div class="info right">
                    <div class="box">Individual results may vary. To protect the privacy of the individuals, we reserve the right to change names or photographs. Endorsements may be remunerated.</div>
                    <div class="box">This statement has not been evaluated by the FDA. Products and statements have not been evaluated by the European Medicines Agency or Food and Drug Administration. This product is not intended to diagnose, treat, cure, or prevent any disease. The information on this website is not medical advice. <a style="color:#f1c61a" target="_blank" href="#">Click here</a> to find evidence of a test, analysis, research or study describing the benefits, performance or efficacy of product ingredients based on the expertise of relevant professionals.</div>
                    <div class="copyright">Copyright © <script>
                            const date = new Date;
                            document.write(date.getFullYear())
                        </script> <?php echo $configs->step_1_name; ?>. <br class="mobile__show">All rights reserved. </div>
                </div>
                <div class="clear"></div>
            </div>
        </section>

        <section class="fixed-mobile-button"> <a href="javascript:void(0)" class="button" id="mobile-order-form">Rush my order</a> </section>
    </div>

    <div class="safe-buy"></div>

    <section class="popup-loading-wrapper" style=" display:none;">
        <div class="popup">
            <figure class="product-image"></figure>
            <p>Reserving Your Bottle Of</p>
            <h2><?php echo $configs->step_1_name; ?></h2>
            <img src="images/loader.png" alt="" class="loading-image">
        </div>
    </section>

    <script type="text/javascript" src="js/jquery-3.6.0.min.js"></script>
    <!-- <script type="text/javascript" src="js/bookmarkscroll.js"></script> -->
    <script type="text/javascript" src="js/owl.carousel.js"></script>
    <script type="text/javascript" src="js/jquery.mask.min.js"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            $('#fields_phone').mask('000-000-0000');

            $(".carousel-testimonials").owlCarousel({
                loop: true,
                autoplay: true,
                autoplaySpeed: 400,
                items: 3,
                responsiveClass: true,
                responsive: {
                    959: {
                        items: 3
                    },
                    768: {
                        items: 2
                    },
                    100: {
                        items: 1
                    }
                },

            });

            $('a.scroll-link-button').on("click", (function(e) {
                var t = $(e.currentTarget).attr("href");
                return t && $("html, body").animate({
                    scrollTop: $(t).offset().top
                }, 500), !1
            }))

            $(".attention-block").delay(500).slideDown("slow");

            $(".icon-close").click(function(e) {
                $(".attention-block").slideUp('slow')
            });

            $(".third-section main article.item-1 .more-button").on("click", (function() {
                $(".third-section main .info").fadeOut(300), $(".third-section main .info.item-1").fadeIn(300)
            }))

            $(".third-section main article.item-2 .more-button").on("click", (function() {
                $(".third-section main .info").fadeOut(300), $(".third-section main .info.item-2").fadeIn(300)
            }))

            $(".third-section main article.item-3 .more-button").on("click", (function() {
                $(".third-section main .info").fadeOut(300), $(".third-section main .info.item-3").fadeIn(300)
            }))

            $(".third-section main article.item-4 .more-button").on("click", (function() {
                $(".third-section main .info").fadeOut(300), $(".third-section main .info.item-4").fadeIn(300)
            }))


            $(".third-section main .info.item-1 .next-info-link").on("click", (function() {
                $(".third-section main .info").fadeOut(300), $(".third-section main .info.item-2").fadeIn(300)
            }))

            $(".third-section main .info.item-2 .next-info-link").on("click", (function() {
                $(".third-section main .info").fadeOut(300), $(".third-section main .info.item-3").fadeIn(300)
            }))

            $(".third-section main .info.item-3 .next-info-link").on("click", (function() {
                $(".third-section main .info").fadeOut(300), $(".third-section main .info.item-4").fadeIn(300)
            }))

            $(".third-section main .info .close-info-link").on("click", (function() {
                $(".third-section main .info").fadeOut(300)
            }))

        });
    </script>
    <div class="modal softModal">
    <div class="modal-inner soft-modal-inner">
        <a data-modal-close>&times;</a>
        <div class="modal-content soft-modal-content"></div>
    </div>
</div>

<!-- <script>
    var softModal = new VanillaModal.default( {
        modal: ".softModal",
        modalInner: ".soft-modal-inner",
        modalContent: ".soft-modal-content"
    } );
</script> -->

<div id="vmodal" style="display:none"></div>

<div id="vmodal-submitting" style="display:none">
    <div class='vmodal-custom-content'>
        <div style='text-align: center;'>            
            <div style='margin: 20px 0;'><span class='submitting-text'>Submitting Your Information</span><span class='dots'></span></div>  
            
            <div><img src='images/secure.png' width='400'></div>
        </div>
    </div>
</div>



<script>    
    function vmodal()
	{
        $( "a[href='#vmodal']" ).click( function ( e ) {
            e.preventDefault();
            var self = this;
            
            $( "#vmodal" ).load( $( self ).data( "modal-url" ), function () {
                softModal.open( "#vmodal" );
                
                if (typeof popup_callback === 'function') {
                    popup_callback( $( self ).data( "modal-url" ));
                }
            } );
        } );
	}
	
	
    $('.show-after-load').hide();
    
    setTimeout(function() {
        $('.show-after-load').fadeIn('fast');    
    }, 500);
    
    var submitting = false;
    
    $(function() {
		vmodal();            
        
        // $.validate( {
        //     modules: "html5",
        //     scrollToTopOnError: false,
        //     validateOnBlur: true,
        //     errorMessagePosition: "top"
        // } );
        
        $('.toTop').click( function () {
            var body = $( "html, body" );
            body.stop().animate( {
                scrollTop: 0
            }, 500, 'swing', function () {} );
        });   
        
        $(".toForm").click(function() {
            $([document.documentElement, document.body]).animate({
                scrollTop: $("form").offset().top
            }, 500);
        });
                
        if ($('#countdown').length) {
            var timer = 299;
            
            if (typeof localStorage != 'undefined') {
                timer = parseInt(localStorage.getItem('reservation_countdown'));
            }
            
            if (isNaN(timer)) timer = 299;
            
            if (timer < 0 ) timer = 0;
            
            $('#countdown').html(get_time_string(timer));
            
            startTimer(timer, $('#countdown').get('0'));   
        }
        
        animate_dots();

            });
    
    
    if ($('#vmodal-error').length) {
        softModal.open('#vmodal-error');
    }
    
    function animate_dots()
    {
        $('.dots').each(function() {
            let dots = $(this).html();
            
            if (dots.length < 8) {
                dots += '.';
            } else {
                dots = '.';    
            }
            
            $(this).html(dots);
        });
        
        setTimeout(animate_dots, 750);
    }
    
    function startTimer(duration, display) 
    {
        var timer = duration;
        
        setInterval(function () {
            display.textContent = get_time_string(timer);
            
            if (timer) {
                timer--;
            }
            
            if (typeof localStorage != 'undefined') {
                localStorage.setItem('reservation_countdown', timer);
            }
        }, 999);
    }    
    
    function get_time_string(timer)
    {
        var minutes, seconds;
        minutes = parseInt(timer / 60, 10);
        seconds = parseInt(timer % 60, 10);

        minutes = minutes < 10 ? "0" + minutes : minutes;
        seconds = seconds < 10 ? "0" + seconds : seconds;

        return minutes + ":" + seconds + "!";
    }
    
    function vmodal_msg(msg)
    {
        $('.soft-modal-content .vmodal-custom-content .submitting-text').html(msg);
    }
</script>




                </div>
            </div>
        </div>
        
        <script type="text/javascript">
        	document.querySelectorAll('a[href^="#"]').forEach(anchor => {
    anchor.addEventListener('click', function (e) {
        e.preventDefault();

        document.querySelector(this.getAttribute('href')).scrollIntoView({
            behavior: 'smooth'
        });
    });
});
        </script>
        <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js/jquery.autocomplete.min.js"></script>
    <script type="text/javascript" src="js/custom.js"></script>


</body>

</html>